program project1;

uses SysUtils, BaseUnix, TermIO;


function normalize(S:string):string;           // expands any symlink at the end of S
var n, I:integer;
       T:string;
begin
  T:=fpReadLink(S);                            // try to follow a symlink (returns '' if fails)

  if T='' then result:=S else                  // if T is empty, there was no symbolic link present
  begin
    n:=0;
    while pos('../', T)=1 do                   // strip off as many leading "../" from T as possible
    begin
      delete(T,1,3);
      inc(n)                                   // keep count of number of steps
    end;

    inc(n);                                    // +1 to account for removing (old) filename at end of S

    while n>0 do                               // strip off (old) filename and directories from end of S
    begin
      I:=length(S)-1;                          // new length for S with the last character removed
      setlength(S, I);                         // we trim one character at a time...
      if (I=0) or (S[I]='/') then dec(n)       // and count down for each "/" found; falls through if S=''
    end;                                       // when the loop exits it should leave a trailing "/"

    T:=S+T;                                    // concatenate the two trimmed strings
    repeat
      I:=pos('//', T);                         // fixup for any double "//" where S and T are joined
      if I<>0 then delete(T, I, 1)             // (in the present application this should never happen)
    until I=0;

    result:=T                                  // return an absolute path
  end
end;


type
   TSerialStruct = packed record case integer of 0:(
           _type           :Cardinal;
           line            :Cardinal;
           port            :Cardinal;
           irq             :Cardinal;
           flags           :Cardinal;
           xmit_fifo_size  :Cardinal;
           custom_divisor  :Cardinal;
           baud_base       :Cardinal;
           close_delay     :Word;
           io_type         :Byte;
           reserved_char   :Byte;
           hub6            :Cardinal;
           closing_wait    :Word; // time to wait before closing
           closing_wait2   :Word; // no longer used...
           iomem_base      :PtrUInt;
           iomem_reg_shift :Word;
           port_high       :Cardinal;
           iomap_base      :Cardinal; // cookie passed into ioremap
           ); 1:(buffer:array [0..1023] of Byte)
   end;


var DeviceName, DriverPath, S:string;
                           SR:TSearchRec;
                            T:text;
                            I:integer;
                           FD:longint;
                           SS:TSerialStruct;
                           ck:string;

const C1:integer=0;
      C2:integer=0;

var LinuxInfo: UtsName;


begin
  writeln('test for revised serial port finder method, 13-dec-2024');

  if FindFirst('/dev/tty*', faAnyFile , SR)=0 then
  repeat
    DeviceName:=SR.Name;

    if (DeviceName<>'.') and (DeviceName<>'..') then
    if FileExists('/sys/class/tty/'+DeviceName+'/device/driver')  or           // this suffices with FPC prior to 3.20
       DirectoryExists('/sys/class/tty/'+DeviceName+'/device/driver')  then    // from FPC 3.20 onwards we need this instead
    begin
      S:='/sys';
      S:=normalize(S+'/class');                                                // need all this palaver just so we can
      S:=normalize(S+'/tty');                                                  // check that DriverPath does not begin
      S:=normalize(S+'/'+DeviceName);                                          // with "/sys/bus/serial-base", as this
      S:=normalize(S+'/device');                                               // would indicate a real ttySxx under
      S:=normalize(S+'/driver');                                               // kernel 6.8+

      DriverPath:=S;

      if (pos('/sys/bus/serial-base/', DriverPath)<>1) and
         (ExtractFileName(DriverPath)<>'serial8250') then writeln(DeviceName, ' is a removable device') else
      begin
        S:='/sys/class/tty/'+DeviceName+'/type';       // MUCH easier to find the "type" file here!

        try                                            // access may be blocked with pre-6.8 kernels
          ck:='(/type)';
          I:=-1;
          assign(T, S);
          reset(T);
          if not eof(T) then readln(T, I);
          close(T)
        except inc(C1) end;

//      I:=-1;                                         // uncomment to force use of TIOCGSERIAL ioctl check

        if I<0 then                                    // we arrive here if we could not read the "type" file
        begin
          ck:='(ioctl)';
          FD:=fpOpen('/dev/'+DeviceName, O_RDWR or O_NONBLOCK or O_NOCTTY);
          if FD>0 then
          try
            if fpIOCtl(FD, TIOCGSERIAL, @SS)<>-1 then I:=SS._type;
            fpclose(FD)
          except inc (C2) end
        end;

        if I>0 then                                    // 0 -> unknown: no hardware present
        begin                                          // -1 -> unable to perform either checks
          case I of 0:S:='unknown';
                    1:S:='8250 UART';
                    2:S:='16450 UART';
                    3:S:='16550 UART';
                    4:S:='16550A UART'
                 else S:='other ('+IntToStr(I)+')'
          end; {of case}
          writeln(DeviceName, ' is type ', S, '    ', DriverPath, '    ', ck)
        end
      end
    end
  until FindNext(SR) <> 0;
  FindClose(SR);

  writeln;
  if C1<>0 then
  begin
    writeln('>>> ', C1:2, ' errors reading /type');
    writeln('>>> ', C2:2, ' errors reading ioctl')
  end;

  if FpUname(LinuxInfo)=0 then
  with LinuxInfo do writeln('>>> ', Sysname, ' ',Nodename,' ',Release)
end.

